       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. PRODUPD.                                            
       AUTHOR. D BERT.                                          
                                                                        
      ******************************************************************
      * THIS PROGRAM READS A FILE OF TRANSACTIONS And UPDATES the      *
      * PRODUCT MASTER FILE. PRODUCTS THAT DO NOT EXIST ON THE MASTER  *
      * WILL BE ADDED                                                               *  
      ******************************************************************
                                                                        
       ENVIRONMENT DIVISION.                                            
       CONFIGURATION SECTION.                                           
       SOURCE-COMPUTER. IBM-370.                                        
       OBJECT-COMPUTER. IBM-370.                                        
       INPUT-OUTPUT SECTION.                                            
                                                                        
       FILE-CONTROL.                                                    
           SELECT PROD-MASTER         ASSIGN TO PRODUCT                
                  ORGANIZATION IS INDEXED                               
                  ACCESS IS RANDOM                                      
                  RECORD KEY IS PRM-PRODUCT-CODE.
                            
           SELECT TXN-FILE            ASSIGN TO IN-S-PRODTXN.           
           SELECT ERROR-FILE          ASSIGN TO OUT-S-ERRORS. 
           SELECT RPT-FILE            ASSIGN TO OUT-S-RPT.                                                            

       DATA DIVISION.                                                   
                                                                        
       FILE SECTION.                                                    
       FD  PROD-MASTER                                                   
           LABEL RECORDS ARE STANDARD.                                  
                                                                        
       COPY PRODUCT. 
                                                                               
       FD  TXN-FILE                                                  
           RECORDING MODE IS F                                          
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD.                                  
       01  TXN-RECORD.                                                  
           05  FILLER                          PIC X(80).       

       FD  ERROR-FILE                                                  
           RECORDING MODE IS F                                          
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD.                                  
       01  ERROR-REC.                                                  
           05  FILLER                          PIC X(132).
                
       FD  RPT-FILE                                                  
           RECORDING MODE IS F                                          
           BLOCK CONTAINS 0 RECORDS                                     
           LABEL RECORDS ARE STANDARD.                                  
       01  RPT-REC.                                                  
           05  FILLER                          PIC X(132).       
                                                                        
       WORKING-STORAGE SECTION.                                         
                                                                        
       77  FILLER                   PIC X(16) VALUE '*** PRODUPDT ***'.     
       
       77  TXN-FILE-FLAG                     PIC X    VALUE 'N'.        
           88  EOF-TXN-FILE                  VALUE 'Y'.                 
                                                                        
       77  CHK-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      
                                             VALUE +5.0.                
       77  CHK-MULTI-PROD-RATE               PIC S9(4)V9(4) COMP-3      
                                             VALUE +0.5.                
       77  SERVICE-INTEREST-RATE             PIC S9(4)V9(4) COMP-3      
                                             VALUE +0.5.                
       77  MMA-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      
                                             VALUE +7.0.                
       77  SAV-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      
                                             VALUE +5.0.                
       77  SERVICE-CHARGE                    PIC S9(4)V9(4) COMP-3      
                                             VALUE +5.00. 
       77  DIRECTION                     PIC S9999 VALUE 0.              
       77  WK-INTEREST                       PIC S9(4)V9(4) COMP-3.     
       77  INTEREST-RATE                     PIC S9(4)V9(4) COMP-3.     
       77  NUMOFDAYS                     PIC S9999 VALUE 0.
       77  DAYS-IN-PERIOD                    PIC S9(9)V9(4) COMP-3.     
       77  DAYS-IN-YEAR                      PIC S9(9)V9(4) COMP-3.
       01  RPT-LINES-WRITTEN                 PIC S9(4) COMP VALUE ZERO.	     
       77  WORK-ACTION-REASON                PIC 9(4).                  
           88  NO-ACTIONS                    VALUE 0000.                
           88  NEGATIVE-BALANCE              VALUE 0042.                
           88  BELOW-MINIMUM                 VALUE 0056.                
           88  MULTI-ACCT                    VALUE 0099.                
           88  MISSING-ACCT                  VALUE 2099.                
                                                                        
       77  ACCT-IO-CNT                       PIC 9(4).                  
       77  TXN-CNT                           PIC 9(4).                  
       77  EX-RPT-LINE-CNT                   PIC 9(4) VALUE 0.          
       77  EX-RPT-PAGE-CNT                   PIC 9(4) VALUE 0.          
       77  ACTION-CNT                        PIC 9(4).                  
       77  WORK-CNT                          PIC 9(4).                  
       77  REM                           PIC S9999 VALUE 0.

       77  WORK-RETURN-CODE                  PIC S9(4) COMP.            
       77  NEW-YORK                          PIC XX VALUE 'NY'. 
       01 WORK-VARS.
           05  DC-YEAR                       PIC S9999 VALUE 0.
           05  DC-MONTH                      PIC S9999 VALUE 0.
           05  DC-DAY1                       PIC S9999 VALUE 0.
           05  CURYEAR                       PIC S9999 VALUE 0.
           05  CURMONTH                      PIC S9999 VALUE 0.
           05  CURDAY                        PIC S9999 VALUE 0.
           05  INT0001                       PIC S9999 VALUE 0.
           05  INT0002                       PIC S9999 VALUE 0.
           05  INT0003                       PIC S9999 VALUE 0.
           05  INT0004                       PIC S9999 VALUE 0.
           05  INT0005                       PIC S9999 VALUE 0.
           05  INT0006                       PIC S9999 VALUE 0.
       
           05  TMP1                          PIC S9999 VALUE 0.
           05  TMP2                          PIC S9999 VALUE 0.
           05  TMP4                          PIC S9999 value 0.
           05  DOW                           PIC X(12).
           05  DOW1                          PIC X(12).
                                                                          
       01  DC-MONTH-TABLE-INIT.                                            
           05  JAN-DAYS                      PIC 9(02) VALUE 31.        
           05  FEB-DAYS                      PIC 9(02) VALUE 28.        
           05  MAR-DAYS                      PIC 9(02) VALUE 31.        
           05  APR-DAYS                      PIC 9(02) VALUE 30.        
           05  MAY-DAYS                      PIC 9(02) VALUE 31.        
           05  JUN-DAYS                      PIC 9(02) VALUE 30.        
           05  JUL-DAYS                      PIC 9(02) VALUE 31.        
           05  AUG-DAYS                      PIC 9(02) VALUE 31.        
           05  SEP-DAYS                      PIC 9(02) VALUE 30.        
           05  OCT-DAYS                      PIC 9(02) VALUE 31.        
           05  NOV-DAYS                      PIC 9(02) VALUE 30.        
           05  DEC-DAYS                      PIC 9(02) VALUE 31.        
                                                                        
       01  DC-MONTH-TAB   REDEFINES DC-MONTH-TABLE-INIT.                      
           05  MM       OCCURS 12 TIMES  PIC 9(02).                    
                                                                        
       01  WS-DATE.                                                  
           05  WS-YY                         PIC X(02).
           05  FILLER                        PIC X.                 
           05  WS-MM                         PIC 9(02).                 
           05  FILLER                        PIC X.                 
           05  WS-DD                         PIC X(02).             
               
                                                                        
       01  PGM-LITERALS.                                                
           05  YES-LITERAL                   PIC X    VALUE 'Y'.        
           05  NO-LITERAL                    PIC X    VALUE 'N'.        
           05  EOF-LITERAL                   PIC X    VALUE 'X'.        
                                                                        
       01  ACTION-REASON-CODES.                                         
           05  ACTION-NEG-BALANCE            PIC 9(4) VALUE 0042.       
           05  ACTION-BELOW-MIN              PIC 9(4) VALUE 0056.       
           05  ACTION-MULTI-ACCT             PIC 9(4) VALUE 0099.       
           05  ACTION-MISSING-ACCT           PIC 9(4) VALUE 2099.
           
       01  TXN-REC.
           05   TXN-PROD-NUM                 PIC X(10).
           05   TXN-SUPP-CODE                PIC XX.
           05   TXN-PROD-TYPE                PIC XX.
           05   TXN-UNIT-PRICE               PIC 9(7)v99.
           05   TXN-QUANTITY-ON-HAND         PIC 9(7).
           05   TXN-PROD-DESC                PIC X(20).
           05   filler                       PIC X(30).

       01  ERROR-RECORD.
           05 ERROR-state-code               PIC XX.
           05 ERROR-PROD-TYPE                PIC XX.
           05 ERROR-PROD-NUM                 PIC X(10).
           05 ERROR-TXN-UNIT-PRICE           PIC 9(7)v99. 
           05 filler			     PIC X(57).

      *     COPY MSTR.
       
       
       01  RPT-FIELDS.
           05   NY-A                         PIC 9(9)V99.
           05   NY-H                         PIC 9(9)V99.
           05   IA-A                         PIC 9(9)V99.
           05   IA-H                         PIC 9(9)V99.
           05   NC-A                         PIC 9(9)V99.
           05   NC-H                         PIC 9(9)V99.
           05   NY-TOT                       PIC 9(9) VALUE 0.
           05   IA-TOT                       PIC 9(9) VALUE 0.
           05   NC-TOT                       PIC 9(9) VALUE 0.
           05   TOT-H                        PIC 9(12) VALUE 0.
           05   TOT-A                        PIC 9(12) VALUE 0.
           05   TOT-ALL                      PIC 9(12) VALUE 0.
           05   ERROR-COUNT                  PIC 9(12) VALUE 0. 
           05   TOT-ERRORS                   PIC 9(12) VALUE 0.  
           05   TOT-ALLA                     PIC 9(12) VALUE 0.                                              
           
       01  RPT-HEADER.
           05   FILLER                       PIC X(30) VALUE SPACES. 
           05   FILLER                       PIC X(38) VALUE
             'DAILY PRODUCT MAINTENANCE UPDATE RUN '.
           05   RPT-DAY-OF-WEEK              PIC X(12).
           05   FILLER                       PIC X VALUE SPACE. 
           05   RPT-DATE                     PIC X(08).                                                                          
           05   FILLER                       PIC X VALUE SPACE. 
           05   RPT-TIME                     PIC X(8). 
           05   FILLER                       PIC X(34) VALUE SPACES. 
           
           
       PROCEDURE DIVISION.                                              
       MAINLINE.                                                             
                                                                        
           PERFORM A000-INITIALIZE-PGM THRU A000-INITIALIZE-PGM-EXIT.                                      
      *                                                                  
           PERFORM M100-PROD-MAINTENANCE                                     
              THRU M100-PROD-MAINTENANCE-EXIT                                
                 UNTIL EOF-TXN-FILE. 

      * COMMENTED OUT BY JASPER JOHNS 10/31/99.                                   
      *    PERFORM REPORT-FINAL-CNTRS. 
                                                            
           PERFORM Z000-CLOSE-PGM THRU Z000-CLOSE-PGM-EXIT. 
                                          
                                                                        
           STOP RUN.                                                    
                                                                        
                                                                        
       M100-PROD-MAINTENANCE.                                                
                                                                        
           READ TXN-FILE  INTO TXN-REC                              
               AT END                                                   
                   MOVE EOF-LITERAL  TO TXN-FILE-FLAG                
                   GO TO M100-PROD-MAINTENANCE-EXIT.                         
                                                                        
           ADD  +1    TO TXN-CNT.                                      
                                                                        
           MOVE TXN-PROD-NUM TO PRM-PRODUCT-CODE.                                
                                                                        
           READ PROD-MASTER  KEY IS PRM-PRODUCT-CODE                          
               INVALID KEY                                              
                   DISPLAY 'READ ERROR : PROD MASTER'                
                   MOVE +4                  TO RETURN-CODE              
                   GO TO M100-PROD-MAINTENANCE-EXIT.                         
                                                                        
                                                                        
           ADD  +1    TO ACCT-IO-CNT.  
           PERFORM P100-DAILY-REPORT-INFO 
                THRU P100-DAILY-REPORT-INFO-EXIT.                      
           PERFORM P200-UPDATE-PROD THRU P200-UPDATE-PROD-EXIT. 
           
                                                                        
       M100-PROD-MAINTENANCE-EXIT.                                           
           EXIT.                                                        
                                                                        
                                                                        
       P200-UPDATE-PROD. 


           MOVE   TXN-UNIT-PRICE TO PRM-UNIT-PRICE.
           MOVE TXN-QUANTITY-ON-HAND TO PRM-QUANTITY-ON-HAND.
                          
           REWRITE PRODUCT-MASTER-RECORD.                                          
                                                                        
       P200-UPDATE-PROD-EXIT.                                                
           EXIT.                                                        
                                                                        
                                                                        
       A000-INITIALIZE-PGM.                                                  
                                                                        
           PERFORM OPEN-FILES.                                          
           
           INITIALIZE RPT-DAY-OF-WEEK
                      RPT-DATE.
                                                                                   
           MOVE ZEROES       TO WORK-ACTION-REASON.                     
           MOVE '01/01/2000' TO WS-DATE.
           
           ACCEPT WS-DATE FROM CURRENT-DATE.
           
           MOVE WS-DATE      TO RPT-DATE. 
           MOVE WS-DD   TO DC-DAY1
           MOVE WS-MM   TO DC-MONTH 
           MOVE WS-YY   TO DC-YEAR 
         
           PERFORM A0010-CALCULATE-DAY-OF-WEEK
           
           MOVE DOW TO RPT-DAY-OF-WEEK.

	   PERFORM X-WRITE-REPORT-HEADER.	      
           
       A000-INITIALIZE-PGM-EXIT.
           EXIT. 
           
                                      

       A0010-CALCULATE-DAY-OF-WEEK.

           MOVE 6 TO REM.
           MOVE 7 TO CURDAY.
           MOVE 12 TO CURMONTH.
           MOVE 1996 TO CURYEAR .
           MOVE 1 TO DIRECTION.

           IF  DC-YEAR  > 2099 OR  DC-YEAR  < 1600 THEN
             MOVE 'INVALID YEAR ' TO DOW1
           ELSE 
             IF DC-MONTH > 12
              OR DC-MONTH < 1 
                MOVE 'INVALID MONTH ' TO DOW1
             ELSE 
                MOVE  DC-YEAR  TO TMP1
                PERFORM DAYS-IN-YEAR
                IF  DC-DAY1 > MM of DC-MONTH-TAB (DC-MONTH) 
                 OR  DC-DAY1 < 1 
                    MOVE 'INVALID DAY' TO DOW1
                ELSE 
                    PERFORM AA0020-MAINCALC.

           MOVE DOW1 TO DOW.

       AA0020-MAINCALC.
           
           IF  DC-YEAR  > CURYEAR  
             MOVE  DC-YEAR  TO INT0001
             MOVE CURYEAR  TO INT0002
             MOVE 1 TO DIRECTION
           ELSE 
             MOVE  DC-YEAR  TO INT0002
             MOVE 2 TO DIRECTION
             MOVE CURYEAR  TO INT0001.
             MOVE INT0002 TO TMP4.
             
           IF  DC-YEAR  NOT EQUAL CURYEAR  
               PERFORM  DC-YEARS.

           IF DC-MONTH > CURMONTH
             MOVE DC-MONTH TO INT0001
             MOVE CURMONTH TO INT0002
             MOVE 1 TO DIRECTION
           ELSE 
             MOVE DC-MONTH TO INT0002
             MOVE 2 TO DIRECTION
             MOVE CURMONTH TO INT0001.

           IF DC-MONTH  NOT EQUAL CURMONTH 
             PERFORM DC-MONTHS.

           IF  DC-DAY1 > CURDAY 
             MOVE  DC-DAY1 TO INT0001
             MOVE CURDAY TO INT0002
             MOVE 1 TO DIRECTION
           ELSE 
             MOVE  DC-DAY1 TO INT0002
             MOVE 2 TO DIRECTION
             MOVE CURDAY TO INT0001.

           IF DC-DAY1 NOT EQUAL CURDAY 
             PERFORM DC-DAYS.

           EVALUATE REM
             WHEN 0 MOVE 'SUNDAY' TO DOW1
             WHEN 1 MOVE 'MONDAY' TO DOW1
             WHEN 2 MOVE 'TUESDAY' TO DOW1
             WHEN 3 MOVE 'WEDNESDAY' TO DOW1
             WHEN 4 MOVE 'THURSDAY' TO DOW1
             WHEN 5 MOVE 'FRIDAY' TO DOW1
             WHEN 6 MOVE 'SATURDAY' TO DOW1
           END-EVALUATE.

       TTY.
           MOVE INT0002 TO TMP1.
           IF DC-MONTH > 2 
             ADD 1 TO TMP1.
           PERFORM DAYS-IN-YEAR.
           
           MOVE NUMOFDAYS TO INT0003.
           DIVIDE 7 INTO INT0003 GIVING  TMP2 REMAINDER INT0003.
           
           IF  DIRECTION = 1 
             ADD INT0003 TO REM
           ELSE 
             SUBTRACT INT0003 FROM REM.

       TTY1.
           DIVIDE 7 INTO INT0003 GIVING  TMP2 REMAINDER INT0003.
           IF  DIRECTION = 1 
             ADD INT0003 TO REM
           ELSE 
             SUBTRACT INT0003 FROM REM.
             
           IF REM < ZERO  
              PERFORM UNTIL REM NOT < ZERO 
                 ADD 7 TO REM
              END-PERFORM
           ELSE  
              DIVIDE 7 INTO REM GIVING TMP2 REMAINDER REM.
              
       TTY2.
           MOVE MM of DC-MONTH-TAB(INT0002) TO INT0003.
           PERFORM TTY1.
           
       DAYS-IN-YEAR.
           DIVIDE 4 INTO TMP1 GIVING INT0006 REMAINDER INT0004.
           DIVIDE 400 INTO TMP1 GIVING INT0006 REMAINDER INT0005.

           IF  INT0004 = 0
            AND INT0005 NOT EQUAL TO 100 
            AND INT0005 NOT EQUAL TO 200
            AND INT0005 NOT EQUAL TO 300
              MOVE 29  TO MM OF DC-MONTH-TAB (2)
              MOVE 366 TO NUMOFDAYS
           ELSE 
              MOVE 365 TO NUMOFDAYS.

       DC-YEARS.
           PERFORM TTY VARYING INT0002 FROM INT0002
             BY 1 UNTIL INT0002 EQUAL INT0001.
             
       DC-MONTHS.
           MOVE  TMP4 TO TMP1.

           PERFORM DAYS-IN-YEAR.
           
           PERFORM TTY2 VARYING INT0002 FROM INT0002 BY 1
             UNTIL INT0002 EQUAL INT0001.
       
       DC-DAYS.
           SUBTRACT INT0002 from INT0001 giving INT0003.
           PERFORM TTY1.  
           
                                                                          
       INIT-ACTION-RECORD. 
      *   REMOVED 12/25/1964
       INIT-ACTION-RECORD-EXIT.
           EXIT.                                             
                                                                        
       Z000-CLOSE-PGM.                                                       
           PERFORM DAILY-FINAL-TOTALS THRU
                   DAILY-FINAL-TOTALS-EXIT.                                                             
           PERFORM CLOSE-FILES.                                         
                                                                       
           MOVE WORK-RETURN-CODE  TO RETURN-CODE.
       Z000-CLOSE-PGM-EXIT. 
           EXIT.                  
                                                                        
                                                                        
       REPORT-FINAL-CNTRS.                                              
                                                                        
           DISPLAY 'TRANSACTION COUNT        =======> ' TXN-CNT.       
           DISPLAY 'ACCOUNT MASTER I/O COUNT =======> ' ACCT-IO-CNT.    
           DISPLAY 'ACTION INITIATION COUNT  =======> ' ACTION-CNT. 
    
    
       P100-DAILY-REPORT-INFO.

           
           EVALUATE TRUE 
               WHEN TXN-SUPP-CODE =  'NC'
                   DISPLAY 'PROCESSING NC PRODUCT RECORD'
                   ADD 1 TO NC-TOT
                   PERFORM NC-PROCESSING THRU NC-PROCESSING-EXIT
               WHEN TXN-SUPP-CODE = 'NY'  
                   DISPLAY 'PROCESSING NY PRODUCT RECORD'
                   ADD 1 TO NY-TOT 
                   PERFORM NY-PROCESSING THRU NY-PROCESSING-EXIT
                   GO TO P100-DAILY-REPORT-INFO-EXIT
               WHEN TXN-SUPP-CODE = 'IA'
                   DISPLAY 'PROCESSING IA PRODUCT RECORD'
                   ADD 1 TO IA-TOT
                   PERFORM IA-PROCESSING THRU IA-PROCESSING-EXIT
                   GO TO P100-DAILY-REPORT-INFO-EXIT
               WHEN OTHER
                   DISPLAY 'UNKNOWN SUPPLIER CODE '
                   DISPLAY 'RECORD WAS ' TXN-REC
                   MOVE TXN-REC TO ERROR-RECORD
                   ADD 1 TO ERROR-COUNT
           END-EVALUATE.

       P100-DAILY-REPORT-INFO-EXIT.
           EXIT.                                                                
       
       
       NC-PROCESSING.
           IF TXN-PROD-TYPE = 'H'
              COMPUTE NC-H = (NC-H 
                           + (TXN-UNIT-PRICE * TXN-QUANTITY-ON-HAND)) 
           ELSE 
              COMPUTE NC-A = ( NC-A  
                           + (TXN-UNIT-PRICE * TXN-QUANTITY-ON-HAND)). 
       NC-PROCESSING-EXIT.
           EXIT.

       NY-PROCESSING.
           IF TXN-PROD-TYPE = 'H'
              COMPUTE NY-H = NY-H + TXN-UNIT-PRICE
           ELSE 
              COMPUTE NY-A = NY-A + TXN-UNIT-PRICE.
       NY-PROCESSING-EXIT.
           EXIT.

       IA-PROCESSING.
           IF TXN-PROD-TYPE = 'H'
              COMPUTE IA-H = IA-H + TXN-UNIT-PRICE
           ELSE 
              COMPUTE IA-A = IA-A + TXN-UNIT-PRICE.
       IA-PROCESSING-EXIT.
           EXIT.
       
       DAILY-FINAL-TOTALS.

           COMPUTE TOT-H = NC-H + NY-H + IA-H.
           COMPUTE TOT-A = NC-A + NY-A + IA-A.
           DISPLAY TOT-H.
           DISPLAY TOT-A.
           DISPLAY ERROR-COUNT.
           COMPUTE TOT-ALL = TOT-H + TOT-A + ERROR-COUNT.
           DISPLAY TOT-ALL.
      * CALLS TOPRODUCE THE VARIOUS RPTS
           CALL 'RPTH' USING TOT-H.
           CALL 'RPTA' USING TOT-A.
           CALL 'TOTALRPT' USING TOT-ALL.
       DAILY-FINAL-TOTALS-EXIT.
           EXIT.
                                                                
       OPEN-FILES.                                                      
                                                                        
           OPEN  INPUT  TXN-FILE 
                 OUTPUT ERROR-FILE 
                        RPT-FILE                                    
                 I-O    PROD-MASTER.  
                                   
       ERROR-HANDLING.

           COMPUTE TOT-ERRORS = TOT-ERRORS + ERROR-COUNT.
           MOVE  ERROR-RECORD TO ERROR-REC.
           WRITE ERROR-REC.
                                                                 
       CLOSE-FILES.                                                     
                                                                        
           CLOSE TXN-FILE 
                 ERROR-FILE 
                 RPT-FILE                                           
                 PROD-MASTER.                                            
       
       X-WRITE-REPORT-HEADER.
       
	   WRITE RPT-REC FROM RPT-HEADER
		AFTER ADVANCING PAGE. 

	   ADD 1 TO RPT-LINES-WRITTEN.
		
       X-WRITE-REPORT-HEADER-EXIT.
           EXIT.


      
      
